.H 1 Introduction
Welcome to the pi debugger!
Pi(Process Inspector) is a window-based interactive debugger
for C, C++, and assembler programs.
It provides a network of windows for each program it controls,
allowing programs to be examined from different perspectives.
Pi can attach to running programs, debug multiple processes concurrently,
and monitor the values of C expressions on-the-fly, with only minor impact on 
the timing of a running program.
.P
This Help window provides detailed descriptions of pi's user interface,
window types, window layout, and mouse and keyboard operators.
New users should read the "OpenLook Interface" and "Window Types"
sections first, and then the window descriptions, as needed.
Topics of interest may be displayed several ways:
.AL 1
.LI
For the description of a window and its operators,
select entries in the "help" sub-menu that is available in the
"edit" menu in every window's menu bar.
.LI
Select text in any window (except the Keyboard Input window)
and type the character "?" followed by a carriage return.
This scrolls the Help window to the description of the
current keyboard language.
.LI
Select entries in the "topics" pop-up window that is available in
the Help window's menu bar.
.LE
.H 2 "Starting Pi"
To start pi, place the directory where it is installed on your PATH and type:
.DS I N
pi &
.DE
.P
On start-up, pi starts pads, its companion user interface process,
and creates two windows on the screen:
the Unix Pi window and the Keyboard Input window.
These windows are described in the "Unix Pi Window"
and "Keyboard Input Window" sections.
The default window layouts, fonts, and colors are determined by X
resources (see "X Resources").
.H 2 "Pads"
Pi is implemented with two processes, pi and pads, that are connected to each
other with a bidirectional pipe (Unix domain socket).
Pads is a C program that provides the user interface and manages
the display, keyboard and mouse.
Pi, the debugger, is a C++ program that does everything else: it controls
processes using the debug primitives provide by the Unix operating system,
manages the symbol table and source files, and executes the operators
selected in the menus or entered from the keyboard.
The user interface is separated from the debugger for several reasons:
.AL 1
.LI
Pads can be customized to run in different windowing environments
without having to modify the debugger.
.LI
Pads is responsive to user requests, such as popping up menus,
even when pi is busy performing complex operations.
.LI
Pi and pads may execute on different machines.
When debugging remotely, the network traffic between pi and pads
is much less than the network traffic between pads and the X server.
In addition, pads may be used to to debug programs remotely with
window systems that do not support network connections.
.LE
.H 2 "Remote Execution"
You have two options for running the OpenLook version of pi on a remote machine.
.AL 1
.LI
Run both pi and pads on the remote machine and use X's networking
facilities to connect to the local display.
On the local machine enable X connections from the remote system with the
xhost command, and on the remote system set the X11 environment
variable DISPLAY to the name of the local display before pi is started.
For example, if the hostname of the workstation running the X server
is daksun and the remote machine's hostname is integral:
.DS I N
daksun% xhost +integral
integral being added to access control list
daksun% rlogin integral
integral% DISPLAY=daksun:0
integral% export DISPLAY
integral% pi &
.DE
.LI
Run pads locally and pi on the remote machine.
This will result in much less Ethernet traffic.
To do this, the directory containing the pi binary on the remote
system should be set in the JTOOLSBIN environment variable,
and pi should be invoked with the -r option on the local machine.
For example, if the pi binary resides in the directory /usr/local/bin
on the remote machine named integral:
.DS I N
daksun% JTOOLSBIN=/usr/local/bin
daksun% export JTOOLSBIN
daksun% pi -r integral &
.DE
.P
If the JTOOLSBIN environment variable is not set pi assumes
that the pi binary resides in the directory /usr/jtools/bin
on the remote system.
.LE
.H 2 "Stack Trace"
Pi may be used to print a stack trace of a core dump on the
standard output with the command:
.DS I N
pi -t core_file symbol_table_file
.DE
.P
The symbol table file should be the name of the executable file
that generated the core dump.
Starting at the call to main, pi will print the symbolic location
of the program counter, and the values of arguments and local variables
for every function that was active when the error occurred.
When started with the -t option, pi does not use the window system
or start pads.
.H 2 "Compiling"
Programs that are going to be debugged with pi should
be compiled with the -g option.
If Sun's unbundled compiler is used with SunOS 5.0 (Solaris 2.0) or later
on SPARCs, the -xs option should also be used.
These place additional symbol table information for
debugging purposes in the executable file,
such as mappings between C statements and assembly instructions,
detailed descriptions of user defined types, as well as type and location
information for functions, local and global variables, and arguments.
Only files compiled with -g will appear in the Source Files window for
a process.
On most machines, the -g option is incompatible with the -O option,
so it will not be possible to debug symbolically files compiled with
the optimizer at the source code level.
.H 2 "C++ Code"
Pi is a good tool for debugging C++ code, but only supports a few
C++ specific features:
.AL 1
.LI
It has a built-in C++ name de-mangler to convert the complex variable
names generated by cfront back into their original names.
The de-mangler is compatible with version 3.0 of USL C++.
.LI
Source Text windows generate special menus when several functions are
generated by a single line of source code.
These menus allow the functions to be treated individually or as a group.
Code generated by C++ templates and C++ in-line functions that are not
coded in-line use these facilities.
.LI
The "func index" menu in Source Text windows lists the argument prototypes
for C++ functions, to allow overloaded function names to be distinguished.
.LI
Pi's expression interpreter allows the character sequence "::" to be embedded
in identifiers.
.LE
.P
Pi does not have a C++ expression interpreter, and treats C++ code as C.
Even though cfront generates C structs that may be different
from the C++ classes you write, pi's tools for browsing through C data
structures allow you to find the correspondence between the C++ and
generated C with a minimal amount of effort. 
While a C++ expression interpreter would improve things,
pi does a reasonable job treating C++ code as C. 
.H 2 Distribution
This version of pi is proprietary to AT&T, and should not be distributed outside
the company without permission from Department BL0112280.
Within AT&T, it may be redistributed freely.
.P
I maintain a mailing list of users for updates and propaganda.
If you would like to be added, send electronic or paper mail to:
.DS I N
	David Kapilow
	AT&T Bell Laboratories
	Room 2C-479
	600 Mountain Ave
	P. O. Box 636
	Murray Hill, N. J. 07974-0636
Phone:	(908)-582-3596
Email:	research!dak or dak@research.att.com
.DE
.P
The mail should state whether you would like to receive future
binary distributions, or just email descriptions of the new features.
Bug reports, complaints, compliments, and suggestions are also welcome.
